//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help

//constructed 4/2/05

//tracks pitch, audio input, onset detection up to the human of course!

FreeImprovisationHuman {

	var <ownideas, <mostrecentidea; //stores own most recent, can be stolen by others as one option
	var s,freqbus;
	var <index; 
	var listener, qitchbuffer;
	var whichfrag;
	
	*new {arg index=8,s;
		^super.new.initFreeImprovisationHuman(index,s);	
	}
	
	initFreeImprovisationHuman {arg ind,server;
		
		s=server; 
		
		index=ind;
			
			ownideas= Array.fill(10,{arg i; nil});
		
		
		mostrecentidea=0;
		whichfrag=0;
		
		//for safety start with dummy materialList.new; //collect as go
		
		freqbus=Bus.control(s,1);
		
		qitchbuffer = Buffer.read(s, "QspeckernN4096SR44100.wav"); 
		//this line is absolutely essential! You must load the data required by the UGen! 

	}
	
	setuplistening {arg group;	
	listener=Synth.head(group,\freeimprovisationpitchdetect,[\bus,index,\threshold,0.85,\databufnum,qitchbuffer.bufnum,\ampbufnum, -1, \trigID, index, \freqbus, freqbus.index]);

	}

	
	//for pitch detection, collects motifs
	
	setupresponder {
		var lasttime, ioi, nextfragsize, fragdone, lastfreq, nextfrag, whichfrag;
		var freq, nextfreq;
		
		lasttime=0.0; //Main.elapsedTime;
		freq=nil;
		nextfreq=nil;
		
		nextfragsize=rrand(1,5);
		fragdone=nextfragsize;
		whichfrag=0;
		
		//get freq 50 times per second
		SystemClock.sched(0.0,{
		
		freqbus.get({arg gotfreq; 
		
		freq=nextfreq;
		nextfreq=gotfreq; //so available immediately	
		
		//freq.postln;
		});
		
		0.02});
		 
	
		 OSCresponderNode(s.addr,'/tr',{	 arg time,responder,msg;
				var id,dur; 
				
				id=msg[2];
									
				if((id==index),{	
				
					//["human", id,index].postln;	
				
					//["human triggered",time].postln;
				
					//store ioi,pitches into melodic fragments
					ioi=time-lasttime;
					
					if((ioi<3.0) && (ioi>0.01),{
										
					//["check ioi", time,lasttime,ioi].postln;
				
					lasttime=time;
				
					//every 50 change pitch sensitivity?
					if(0.02.coin,{
					listener.set(\threshold,exprand(0.8,1.1));
					});
					
					//getpitch from freqbus
					
					//freqbus.get({arg freq; 
						
						//"got freq".postln;
						
						if(freq.notNil,{
						
						//["frag check", nextfragsize,fragdone].postln;
						
						if(nextfragsize==fragdone,{
						
						if(nextfrag.notNil,{
						ownideas[whichfrag]=nextfrag;
						});
						
						//Post << "ownideas " <<  ownideas << nl; 
						
						mostrecentidea=whichfrag; 
						
						whichfrag=(whichfrag+1)%10;
						
						nextfragsize=rrand(1,5);
						nextfrag= Array.fill(nextfragsize,nil);
						fragdone=0;
						
						});
						
						//["fragnote", freq, ioi].postln;
						
						//safety
						if((freq>100) && (freq<1200),{ 
						
						//quantise freq to semitones? 
						
						//freq= freq.cpsmidi.round(1.0).midicps;
						
						nextfrag[fragdone]=[freq,ioi];
						
						//fragdone.postln;
						
						fragdone=fragdone+1;
						});
						
						});
					
						//lastfreq=freq;
						
					//});
					
					},{
					lasttime=time;
					
					});
				
					 
					
			});
			
		}).add;
		
			
	
	}


	*initClass {
	
		StartUp.add({
	
		SynthDef(\freeimprovisationpitchdetect,{arg bus=8,threshold=0.85,databufnum,ampbufnum, trigID, freqbus;
		
		var input, freq,hasfreq, onsetdetect;
		
			input= InFeedback.ar(bus);
			
			#freq,hasfreq= Qitch.kr(input, databufnum, 0.01, 1, ampbufnum, 150, 1000); 
			
			Out.kr(freqbus, freq); 
					
			OnsetDetection.ar(input,threshold,trigID); //same trig ID as own bus number
		
		}).writeDefFile;
		
		});


	}

}